#!/bin/sh

MASTER_PAGE_SSHD_ENABLE_RESULT_MSG=""
MASTER_PAGE_SSHD_ENABLE_RESULT_OK=0
MASTER_PAGE_SSHD_ENABLE_RESULT_ERROR=1

MASTER_PAGE_SSHD_ENABLE_RESULT_CODE=${MASTER_PAGE_SSHD_ENABLE_RESULT_ERROR}
MASTER_PAGE_SSHD_ENABLE_RESULT_ROLLING=0

master_page_sshd_enable() {
        dprint "DEBUG" "===== Enable/Disable ssh ====="		
        local ssh_enabled=false
        local checked=" [X] "
        local unchecked=" [ ] "
	local menu_list

        systemctl status sshd.service >/dev/null 2>&1
        local status="$?"
        dprint "DEBUG" "sshd.service status: [${status}]"
        if [ "${status}" != "0" ]; then
            menu_list="\"${unchecked}\" \"${MASTER_PAGE_SSHD_ENABLE_ITEM_ENABLE}\" \"${checked}\" \"${MASTER_PAGE_SSHD_ENABLE_ITEM_DISABLE}\""
            ssh_enabled=false
        else
            menu_list="\"${checked}\" \"${MASTER_PAGE_SSHD_ENABLE_ITEM_ENABLE}\" \"${unchecked}\" \"${MASTER_PAGE_SSHD_ENABLE_ITEM_DISABLE}\""
            ssh_enabled=true
        fi
	
	##################################################
	# display menu - cluster setting
	##################################################
	tp_menu_ok_cancel \
		"${MASTER_PAGE_SSHD_ENABLE_TITLE}" \
		"${MASTER_PAGE_SSHD_ENABLE_TEXT}" \
		"${MASTER_PAGE_SSHD_ENABLE_OK_LABEL}" \
		"${MASTER_PAGE_SSHD_ENABLE_CANCEL_LABEL}" \
		"$menu_list" \
                "" \
                "${checked}" 
		
	# if user choose CANCEL or ESC, roll back to main setting page
	if [ "${TP_MENU_OK_CANCEL_RESULT_CODE}" == "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" ]; then
		MASTER_PAGE_SSHD_ENABLE_RESULT_CODE=$MASTER_PAGE_SSHD_ENABLE_RESULT_OK
		MASTER_PAGE_SSHD_ENABLE_RESULT_ROLLING=-1
		return
	fi
	#debug_print $0 $LINENO "[Account Management] user choose: $TP_MENU_OK_CANCEL_RESULT_SELECT"
	
	##################################################
	# Perform action
	##################################################
 
        if [ "${TP_MENU_OK_CANCEL_RESULT_SELECT}" == "${checked}" ]; then
            dprint "DEBUG" "Status not changed, do nothing."
        else
          if [ ${ssh_enabled} != false ]; then
            # Disable ssh
            dprint "DEBUG" "Disable sshd.service"
            systemctl stop sshd.service >/dev/null 2>&1       
            if [ "$?" != "0" ]; then
                dprint "ERROR" "Failed to enable sshd.service"
                MASTER_PAGE_SSHD_ENABLE_RESULT_CODE=${MASTER_PAGE_SSHD_ENABLE_RESULT_ERROR}
                MASTER_PAGE_SSHD_ENABLE_RESULT_MSG=${MASTER_PAGE_SSHD_ENABLE_SYSTEM_ERROR}
                MASTER_PAGE_SSHD_ENABLE_RESULT_ROLLING=-1
                return
            else
                # Kill current login sessions
                dprint "DEBUG" "Kill current logon sessions.."
                ps -ef | grep 'sshd' | grep root@notty | awk '{print $2}' | xargs kill -9 >/dev/null 2>&1
                who -u | awk '$2 !~ /tty/ {print $6}' | xargs kill -9 >/dev/null 2>&1
                ps aux | grep -v grep | grep '\-admin_shell' | awk '$7 !~ /tty/ {print $2}' | xargs kill -9 >/dev/null 2>&1
            fi
          else
            # Enable ssh
            dprint "DEBUG" "Enable sshd.service"
            systemctl start sshd.service >/dev/null 2>&1
            if [ "$?" != "0" ]; then
                dprint "ERROR" "Failed to enable sshd.service"
                MASTER_PAGE_SSHD_ENABLE_RESULT_CODE=${MASTER_PAGE_SSHD_ENABLE_RESULT_ERROR}
                MASTER_PAGE_SSHD_ENABLE_RESULT_MSG=${MASTER_PAGE_SSHD_ENABLE_SYSTEM_ERROR}
                MASTER_PAGE_SSHD_ENABLE_RESULT_ROLLING=-1
                return
            fi
          fi
        fi
        
        dprint "DEBUG" "===== End enable/disable ssh ====="    
	MASTER_PAGE_SSHD_ENABLE_RESULT_CODE=$MASTER_PAGE_SSHD_ENABLE_RESULT_OK
	MASTER_PAGE_SSHD_ENABLE_RESULT_ROLLING=0
}

